/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.widgets;

import com.quantumdata.widgets.KeyBoardDlg;
import com.quantumdata.widgets.QDEditButton;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class QDEditField
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    public static final int NUMERIC_INT = 1;
    public static final int NUMERIC_FLOAT = 2;
    public static final int ALPHA_NUMERIC = 3;
    private int m_type;
    private QDEditButton m_button = null;
    private StringBuffer m_textBuffer;
    private int m_fieldLen = 10;
    private JTextField m_textField = null;
    private String m_prompt = "Enter a Value";
    private static Font m_font = null;
    public static boolean g_keyboardPresent = false;

    public QDEditField(int n) {
        this.m_type = n;
        this.initComponents();
    }

    public QDEditField(int n, String string) {
        this.m_type = n;
        this.initComponents();
        this.setValue(string);
    }

    public QDEditField(int n, String string, int n2) {
        this.m_type = n;
        this.m_fieldLen = n2;
        if (this.m_fieldLen < 4) {
            this.m_fieldLen = 4;
        }
        this.initComponents();
        this.setValue(string);
    }

    public QDEditField(int n, String string, int n2, String string2) {
        this.m_type = n;
        this.m_fieldLen = n2;
        this.m_prompt = string2;
        if (this.m_fieldLen < 4) {
            this.m_fieldLen = 4;
        }
        this.initComponents();
        this.setValue(string);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = this.m_type == 3 ? KeyBoardDlg.getText(this.m_prompt, this.getValue()) : KeyBoardDlg.getNumber(this.m_prompt, this.getValue());
        if (string != null && string.length() > 0) {
            this.setValue(string);
        }
    }

    public void setType(int n) {
        this.m_type = n;
    }

    public int getType() {
        return this.m_type;
    }

    public void setValue(String string) {
        if (this.m_button != null) {
            this.m_textBuffer.setLength(0);
            this.m_textBuffer.append(string);
            this.setButtonText();
        } else {
            this.m_textField.setText(string);
        }
    }

    public String getValue() {
        if (this.m_button != null) {
            return this.m_textBuffer.toString();
        }
        return this.m_textField.getText();
    }

    public void setPrompt(String string) {
        this.m_prompt = string;
    }

    private void setButtonText() {
        int n;
        StringBuffer stringBuffer = new StringBuffer(this.m_textBuffer);
        if (n <= this.m_fieldLen) {
            for (n = this.m_textBuffer.length(); n < this.m_fieldLen; ++n) {
                stringBuffer.append(' ');
            }
        } else {
            stringBuffer.setLength(this.m_fieldLen - 3);
            stringBuffer.append("...");
        }
        this.m_button.setText(stringBuffer.toString());
    }

    private void initComponents() {
        if (m_font == null) {
            m_font = new Font("Monospaced", 1, 12);
        }
        this.setLayout(new BorderLayout());
        if (g_keyboardPresent) {
            this.m_textField = new JTextField(10);
            this.m_textField.setFont(m_font);
            this.add((Component)this.m_textField, "Center");
        } else {
            this.m_button = new QDEditButton();
            this.m_button.setFont(m_font);
            this.m_button.setBackground(Color.lightGray);
            this.m_button.addActionListener(this);
            this.m_button.setActionCommand("EDIT");
            this.m_textBuffer = new StringBuffer();
            this.add((Component)this.m_button, "Center");
        }
    }
}

